//
//  AboutAppInformationViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 21.02.23.
//

import UIKit

class AboutAppInformationViewController : UIViewController {
    

    @IBOutlet var backButton: UIButton!
    
    @IBOutlet var appInformationHeaderLabel: UILabel!
    
    @IBOutlet var aboutThisAppHeaderLabel: UILabel!
    @IBOutlet var aboutThisAppDetailsLabel: UILabel!
    
    @IBOutlet var publisherHeaderLabel: UILabel!
    @IBOutlet var publisherDetailsLabel: UILabel!
    
    @IBOutlet var contactDetailsHeaderLabel: UILabel!
    @IBOutlet var contactDetailsDetailsLabel: UILabel!
    
    
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : Colors.carmine,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        
        if(!showBackButtonPublic) {
            backButton.isHidden = true
            backButton.isEnabled = false
        }
        
        appInformationHeaderLabel.textColor = Colors.greyColor
        appInformationHeaderLabel.font = Fonts.heavyFontWithSize(size: 17)
        appInformationHeaderLabel.text = "App-Informationen"
        
        

        
        aboutThisAppHeaderLabel.textColor = Colors.greyColor
        aboutThisAppHeaderLabel.font = Fonts.heavyFontWithSize(size: 16)
        aboutThisAppHeaderLabel.text = "Über diese App."
        
        aboutThisAppDetailsLabel.textColor = Colors.greyColor
        aboutThisAppDetailsLabel.font = Fonts.mediumFontWithSize(size: 15)
        aboutThisAppDetailsLabel.text = "Diese App dient zur freiwilligen Teilnahme an Studien und Umfragen. Die App wurde von Wissenschaftler*innen der Ruhr-Universität Bochum entwickelt."
        
        publisherHeaderLabel.textColor = Colors.greyColor
        publisherHeaderLabel.font = Fonts.heavyFontWithSize(size: 16)
        publisherHeaderLabel.text = "Herausgeber"
        
        publisherDetailsLabel.textColor = Colors.greyColor
        publisherDetailsLabel.font = Fonts.mediumFontWithSize(size: 15)
        publisherDetailsLabel.text = "Mobile Security Group (MobSec)\nRuhr-Universität Bochum\nUniversitätsstraße 150\n44801 Bochum\nDeutschland"
        
        
        contactDetailsHeaderLabel.textColor = Colors.greyColor
        contactDetailsHeaderLabel.font = Fonts.heavyFontWithSize(size: 16)
        contactDetailsHeaderLabel.text = "Ansprechpartner"
        

        var textArray_contactDetailsDetailsLabel = [String]()
        var fontArray_contactDetailsDetailsLabel = [UIFont]()
        var colorArray_contactDetailsDetailsLabel = [UIColor]()
        
        textArray_contactDetailsDetailsLabel.append("Marvin Kowalewski")
        textArray_contactDetailsDetailsLabel.append("\nE-Mail:")
        textArray_contactDetailsDetailsLabel.append("mobsec-studies@rub.de")
        
        fontArray_contactDetailsDetailsLabel.append(Fonts.mediumFontWithSize(size: 15.0))
        fontArray_contactDetailsDetailsLabel.append(Fonts.heavyFontWithSize(size: 15.0))
        fontArray_contactDetailsDetailsLabel.append(Fonts.mediumFontWithSize(size: 15.0))
        
        colorArray_contactDetailsDetailsLabel.append(Colors.greyColor)
        colorArray_contactDetailsDetailsLabel.append(Colors.greyColor)
        colorArray_contactDetailsDetailsLabel.append(Colors.greyColor)
        
        self.contactDetailsDetailsLabel.attributedText = getAttributedString(arrayText: textArray_contactDetailsDetailsLabel, arrayColors: colorArray_contactDetailsDetailsLabel, arrayFonts: fontArray_contactDetailsDetailsLabel)
    
        
        
    }
    
    @IBAction func backButton(_ sender: Any) {
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "TEST55")
        
        let layout = UICollectionViewFlowLayout()
        self.view.window?.rootViewController = AuthenticationScreenViewController(collectionViewLayout: layout)
        
        self.view.window?.rootViewController = vc
        self.view.window?.makeKeyAndVisible()
    }
    
    //MARK:- getAttributedString
    func getAttributedString(arrayText:[String]?, arrayColors:[UIColor]?, arrayFonts:[UIFont]?) -> NSMutableAttributedString {
        
        let finalAttributedString = NSMutableAttributedString()
        
        for i in 0 ..< (arrayText?.count)! {
            
            let attributes = [NSAttributedString.Key.foregroundColor: arrayColors?[i], NSAttributedString.Key.font: arrayFonts?[i]]
            let attributedStr = (NSAttributedString.init(string: arrayText?[i] ?? "", attributes: attributes as [NSAttributedString.Key : Any]))
            
            if i != 0 {
                
                finalAttributedString.append(NSAttributedString.init(string: " "))
            }
            
            finalAttributedString.append(attributedStr)
        }
        
        return finalAttributedString
    }

}
